/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

//based on shader from coyote => https://www.shadertoy.com/view/ltfGzS

// matrix op
mat3 getRotYMat(float a){return mat3(cos(a),0.,sin(a),0.,1.,0.,-sin(a),0.,cos(a));}
void main()
{
    vec2 s = iResolution.xy;
    float t = iGlobalTime,t5=t*.2,c=0.;
    vec3 p=vec3((2.*gl_FragCoord.xy-s)/s.x,1.),r=p-p,q=r;
    mat3 rotY = getRotYMat(-t5);
    p*=rotY;
    q.z+=10.+sin(t5)*3.;
   	q.x+=10.+cos(t5)*3.;
    for (float i=1.; i>0.; i-=.01) 
    {
        float d=0.,s=1.;

        for (int j = 0; j < 3 ; j++)
            r=max(r*=r*=r*=r=mod(q*s+1.,2.)-1.,r.yzx),
            d=max(d,( .29 -length(r)*.6)/s)*.8,
            s*=1.1;

        q+=p*d;
        
        c = i;
	    
        if(d<1e-5) break;
    }
    
    float r1 = c, r2 = dot(r,r+.15);
    float rr = min(r1, r2);
    float gg = max(r1, r2);
    float bb = gg/rr;

    gl_FragColor.rgb = vec3(rr,gg,bb)-.8;
    gl_FragColor.a = 1.;
    
}